package com.bxm.newidea.domain;

import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.vo.LocalNews;
import com.bxm.newidea.vo.MixedRecommendPool;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;


@Mapper
public interface MixedRecommendPoolMapper {

    List<MixedRecommendPool> selectRecommandList(@Param("weight") Integer weight,
                                                 @Param("pageSize") Integer pageSize,
                                                 @Param("areaCode") String areaCode,
                                                 @Param("issueTime") Date issueTime);

    List<LocalNews> selectLocalNews(@Param("tableName") String tableName,
                                    @Param("issueTime") Date issueTime,
                                    @Param("pageSize") Integer pageSize);

    List<MixRecomendResult> selectRecentlyRecommendList(@Param("recentlyTime") Date recentlyTime,
                                                        @Param("areaCode") String areaCode);

    List<MixRecomendResult> selectLastRecommendList(@Param("weight") Integer weight,
                                                    @Param("areaCode") String areaCode,
                                                    @Param("pageSize") Integer pageSize);

    List<MixRecomendResult> selectFixRecommendList(@Param("pageSize") Integer pageSize,
                                                   @Param("areaCode") String areaCode);
}
