package com.bxm.newidea.domain;

import java.util.List;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.bxm.newidea.param.NewsQueryParam;
import com.bxm.newidea.vo.News;

@Mapper
public interface NewsMapper {

    News selectByPrimaryKey(Long id);

    List<Long> recommendNews(NewsQueryParam param);

    List<Long> recommendOtherNews(NewsQueryParam param);

    List<Long> recommendNewsWithoutTime(NewsQueryParam param);

    List<Long> recommendOtherNewsWithoutTime(NewsQueryParam param);

    List<News> queryRecommendNewsList(@Param("newsId") Long newsId,
                                      @Param("pageSize") int pageSize,
                                      @Param("userId") Long userId);

    List<News> queryRecommendNewsListWithoutTime(@Param("newsId") Long newsId,
                                                 @Param("pageSize") int pageSize,
                                                 @Param("userId") Long userId);

    List<News> queryVideoList(NewsQueryParam param);

    List<Long> queryRecommendLocalNewsList(@Param("newsId") Long newsId, @Param("pageSize") Integer pageSize,
                                           @Param("userId") Long userId, @Param("province") Long province,
                                           @Param("areaCode") String areaCode);

    List<Long> queryRecommendLocalNewsListWithoutTime(@Param("newsId") Long newsId, @Param("pageSize") Integer pageSize,
                                                      @Param("userId") Long userId, @Param("province") Long province,
                                                      @Param("areaCode") String areaCode);

    List<Long> queryLocalNewShortTermByTime(@Param("province") Long province, @Param("userId") Long userId,
                                            @Param("pageSize") Integer size,@Param("areaCode") String areaCode,
                                            @Param("newsId") Long newsId);

    List<Long> queryLocalNewPerennialByTime(@Param("province") Long province, @Param("userId") Long userId,
                                            @Param("pageSize") Integer size,@Param("areaCode") String areaCode,
                                            @Param("newsId") Long newsId);
}
