package com.bxm.newidea.domain;

import com.bxm.newidea.dto.VideoDto;
import com.bxm.newidea.param.VideoQueryParam;
import com.bxm.newidea.vo.Video;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface VideoMapper {

    int deleteByPrimaryKey(Long id);

    int insert(Video record);

    int insertSelective(Video record);

    Video selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(Video record);

    int updateByPrimaryKey(Video record);

    /**
     * 获取最新的数据用于快速反馈，进行排重处理
     * @param param 查询参数
     * @return 给用户推荐的默认数据
     */
    List<VideoDto> getPublicVideo(@Param("userId") Long userId,@Param("pageSize") Integer pageSize);

    /**
     * 给用户推荐120条（10页）未读的小视频,視頻根据点击量、点赞数综合排序
     * @param userId 用户ID
     * @return 推荐列表
     */
    List<VideoDto> getUserRecommend(@Param("userId") Long userId,@Param("limit") Integer limit);

    /**
     * 更新小视频的点赞的计数器
     * @param videoId 视频ID
     * @param num     点赞数量
     * @return 更新结果
     */
    int updateLikeCounter(@Param("videoId") Long videoId, @Param("num") int num);

}