package com.bxm.newidea.service;

import com.bxm.newidea.param.NewsRecommended;
import com.bxm.newidea.service.fallback.NewsSyncFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(value = "localnews-spider-sync", fallbackFactory = NewsSyncFallbackFactory.class)
public interface NewsSyncFeignService {

     @PostMapping(value = "api/news/sync/recommended")
     ResponseEntity generateRecommeded(@RequestBody List<NewsRecommended> newsRecommendedList);
}

