package com.bxm.newidea.service.fallback;

import com.bxm.newidea.service.BizService;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BizFallbackFactory implements FallbackFactory<BizService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(BizFallbackFactory.class);

    @Override
    public BizService create(Throwable throwable) {
      return () -> {
          LOGGER.error(throwable.getMessage(), throwable);
          return null;
      };
    }
}
