package com.bxm.newidea.service.fallback;

import com.bxm.newidea.service.NewsSyncFeignService;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NewsSyncFallbackFactory implements FallbackFactory<NewsSyncFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsSyncFallbackFactory.class);

    @Override
    public NewsSyncFeignService create(Throwable throwable) {

        return newsSimpleParam -> {
            LOGGER.error(throwable.getMessage(), throwable);
            return null;
        };
    }
}