package com.bxm.newidea.service.fallback;

import com.bxm.newidea.service.WeightService;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WeightFallbackFactory implements FallbackFactory<WeightService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(WeightFallbackFactory.class);

    @Override
    public WeightService create(Throwable throwable) {
        return userId -> {
            LOGGER.error(throwable.getMessage(), throwable);
            return null;
        };
    }
}
