package com.bxm.newidea.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Objects;


@ApiModel(description = "首页推荐逻辑返回封装参数")
@Data

public class MixRecomendResult extends BaseBean {

    /**
     * TODO 可以考虑只传一个值，采用拼接的方式
     */
    @ApiModelProperty("新闻id或帖子id")
    private Long id;

    @ApiModelProperty("来源 1：社区帖子 2：本地新闻 3：全国新闻")
    private String  origin;

    public MixRecomendResult(Long id, String origin) {
        this.id = id;
        this.origin = origin;
    }

    public MixRecomendResult() {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MixRecomendResult that = (MixRecomendResult) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(origin, that.origin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, origin);
    }
}
