package com.bxm.newidea.dto;

import com.bxm.newidea.component.vo.BaseBean;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Objects;

@Data
@ApiModel(description = "视频信息返回到前端的封装参数")
public class VideoDto extends BaseBean {

    @ApiModelProperty("视频ID")
    private Long id;

    @ApiModelProperty("视频显示图片")
    private String videoImg;

    @ApiModelProperty("视频文件播放地址")
    private String videoUrl;

    @ApiModelProperty("视频标题")
    private String title;

    @ApiModelProperty("视频描述")
    private String description;

    @ApiModelProperty("点击次数（播放次数）")
    private Long clickCount = 0L;

    @ApiModelProperty("点赞次数")
    private Long likeCount = 0L;

    @ApiModelProperty("作者名称")
    private String author;

    @ApiModelProperty("作者头像")
    private String authorImg;

    @ApiModelProperty("该视频当前用户是否已点赞")
    private Boolean praise;

    @ApiModelProperty("评论总数")
    private Long commentCount = 0L;

    @ApiModelProperty("高宽比")
    private Double widthRatio;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VideoDto videoDto = (VideoDto) o;
        return Objects.equals(id, videoDto.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
