package com.bxm.newidea.param;

import lombok.Data;

/**
 * <p>
 *     论坛帖子查询数据库参数类
 * </p>
 *
 * @Author: JandMin
 * @since: 1.0.0
 * @Date: 2019/4/4
 */
@Data
public class ForumQueryParam {
    /**
     * 区域编码
     */
    private String areaCode;
    /**
     * 是否精华帖 0否 1是
     */
    private Integer brilliant;
    /**
     * 更早的发布时间
     */
    private String lastTime;
    /**
     * 板块id
     */
    private Long forumId;
    /**
     * 话题id
     */
    private Long topicId;
    /**
     * 返回数量
     */
    private Integer size;
    /**
     * 互动分值
     */
    private Integer hotScore;
    /**
     * 热们标记（为null:非热门 1：热门排序）
     */
    private Integer hot;
    /**
     * 期限(单位：小时 eg 24 小时内)
     */
    private Integer deadline;
}
