package com.bxm.newidea.param;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.IUserIdSharding;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "新闻推荐参数")
@Data
public class NewsQueryParam extends BasicParam implements IUserIdSharding {

    @ApiModelProperty(value = "频道ID", required = true)
    private Long kindId;

    @ApiModelProperty(value = "是否热门频道,根据配置的频道ID来判断", hidden = true)
    private Integer isHot;

    @ApiModelProperty("推荐方式，1：下拉刷新，2：上拉刷新，首次进入为下拉刷新")
    private Byte type;

    @ApiModelProperty("拉取数量，默认20")
    private Integer pagesize = 20;

    @ApiModelProperty("当前是第几次请求（相当于页数），用于控制广告、小视频的插入")
    private Integer curPage = 0;

    @ApiModelProperty(value = "当前请求的用户ID", required = true)
    private Long userId;

    @ApiModelProperty(value = "当前用户的所属区域，用于进行地方新闻推荐")
    private String areaCode;

}
