package com.bxm.newidea.recommend;

import com.bxm.newidea.dto.VideoDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.*;

@Component
public class RecommendEngine {

    private Logger logger = LoggerFactory.getLogger(RecommendEngine.class);

    private RecommendFilter recommendFilter;
    private RecommendManager recommendManager;

    @Autowired
    public RecommendEngine(RecommendManager recommendManager,RecommendFilter recommendFilter) {
        this.recommendManager = recommendManager;
        this.recommendFilter = recommendFilter;
    }

    public  List<Long> recommendNews(Long userId, Integer num){
        List<AbstractRecommender> recommenderWorkers =recommendManager.getNewsRecommenders();
        Iterator<AbstractRecommender> iterator = recommenderWorkers.iterator();
        List<Long> newsIds = new LinkedList<>();
        //fetchNum：权重*当前总新闻数 当某一个策略不足时候 顺序不足
        int fetchNum;
        int differenceNum = 0;
        while (iterator.hasNext()){
            AbstractRecommender recommender = iterator.next();
            fetchNum = new BigDecimal(num).multiply(new BigDecimal(recommender.getWeight())).intValue()+differenceNum;
            List<Long> results = recommender.recommendNews(userId,fetchNum);
            logger.debug("{} 推荐结果：{}",recommender.getClass(),results.size());
            differenceNum = fetchNum-results.size();
            newsIds.addAll(results);
            if(newsIds.size()==num){
                break;
            }
        }
        //全局黑名单过滤
        newsIds = recommendFilter.newsFilter(newsIds);
        //去重
        return removeDuplicateNews(newsIds);
    }

    public  List<Long> recommendNews(Long userId,Integer kindId,Integer num,String areaCode){
        List<AbstractRecommender> recommenderWorkers =recommendManager.getNewsRecommenders();
        Iterator<AbstractRecommender> iterator = recommenderWorkers.iterator();
        List<Long> newsIds = new LinkedList<>();
        //fetchNum：权重*当前总新闻数 当某一个策略不足时候 顺序补足
        int fetchNum;
        int differenceNum = 0;
        while (iterator.hasNext()){
            AbstractRecommender recommender = iterator.next();
            fetchNum = new BigDecimal(num).multiply(new BigDecimal(recommender.getWeight())).intValue()+differenceNum;
            List<Long> results = recommender.recommendNews(userId,kindId,fetchNum,areaCode);
            logger.debug("{} 推荐结果：{}",recommender.getClass(),results.size());
            differenceNum = fetchNum-results.size();
            newsIds.addAll(results);
            if(newsIds.size()==num){
                break;
            }
        }
        //全局黑名单过滤
        newsIds = recommendFilter.newsFilter(newsIds);
        //去重
        newsIds = removeDuplicateNews(newsIds);

        return   newsIds.size()>num?newsIds.subList(0,num):newsIds;
    }

    public  List<VideoDto> recommendVideo(Long userId,Integer num){
        List<AbstractRecommender> recommenderWorkers =recommendManager.getVideoRecommenders();
        Iterator<AbstractRecommender> iterator = recommenderWorkers.iterator();
        logger.debug("视频新闻推荐引擎调用链：{}",recommenderWorkers);
        List<VideoDto> videoDtoList = new LinkedList<>();
        //fetchNum：权重*当前总新闻数 当某一个策略不足时候 顺序不足
        int fetchNum;
        int differenceNum = 0;
        while (iterator.hasNext()){
            AbstractRecommender recommender = iterator.next();
            fetchNum = new BigDecimal(num).multiply(new BigDecimal(recommender.getWeight())).intValue()+differenceNum;
            List<VideoDto> results = recommender.recommendVideo(userId,fetchNum);
            logger.debug("{} 推荐结果：{}",recommender.getClass(),results.size());
            differenceNum = fetchNum-results.size();
            videoDtoList.addAll(results);
            if(videoDtoList.size()==num){
                break;
            }
        }
        //全局黑名单过滤
        videoDtoList = recommendFilter.videoFilter(videoDtoList);
        //去重
        videoDtoList = removeDuplicateVideo(videoDtoList);
        return videoDtoList.size()>num?videoDtoList.subList(0,num):videoDtoList;
    }



    private List<Long> removeDuplicateNews(List<Long> list){
        for(int i = 0;i<list.size()-1;i++){
            for(int j = list.size() - 1;j>i;j--){
                if  (list.get(j).equals(list.get(i))){
                    list.remove(j);
                }
            }
        }
        return list;
    }

    private List<VideoDto> removeDuplicateVideo(List<VideoDto> list){
        HashSet<VideoDto> h = new HashSet<>(list);
        list.clear();
        list.addAll(h);
        return  list;
    }
}
