/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.framework;

import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.param.MixRecommendParam;
import com.bxm.newidea.recommend.AbstractRecommender;
import com.bxm.newidea.vo.CircleNode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;

public abstract class AbstractMixRecommender
extends AbstractRecommender {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected RedisListAdapter redisListAdapter;
    protected RedisSetAdapter redisSetAdapter;
    protected RedisStringAdapter redisStringAdapter;
    protected MixedRecommendPoolMapper mixedRecommendPoolMapper;
    public static HashMap<String, CircleNode[]> mixRecommendResults = new HashMap();

    public AbstractMixRecommender(double weight, int sort) {
        super(weight, sort);
    }

    @Override
    public List<MixRecomendResult> recommend(MixRecommendParam param) {
        long begin = System.currentTimeMillis();
        int num = param.getNum();
        Long userId = param.getUserId();
        String areaCode = param.getAreaCode();
        Integer actionType = param.getActionType();
        List<MixRecomendResult> ids = this.syncRecommend(userId, actionType, num, areaCode);
        AbstractMixRecommender recommender = (AbstractMixRecommender)((Object)SpringContextHolder.getBean(((Object)((Object)this)).getClass()));
        recommender.asyncRecommend(userId, ids);
        this.logger.info("\u63a8\u8350\u7ed3\u679c\uff1a{},\u7528\u6237\uff1a{}\uff0c \u8017\u65f6\uff1a{}", new Object[]{ids == null ? Integer.valueOf(0) : JSONObject.toJSONString(ids), userId, System.currentTimeMillis() - begin});
        return ids;
    }

    protected abstract List<MixRecomendResult> syncRecommend(Long var1, Integer var2, Integer var3, String var4);

    @Async
    protected void asyncRecommend(Long userId, List<MixRecomendResult> mixRecomendResults) {
        KeyGenerator indexCacheKey = RedisKeyConstant.MIX_LAST_READ_TIME.copy().appendKey((Object)userId);
        if (mixRecomendResults != null && !mixRecomendResults.isEmpty()) {
            this.redisStringAdapter.set(indexCacheKey, (Object)new Date(), (long)NewsCacheThresholdConfig.MIX_EXPIRE_LAST_READ_TIME);
        }
    }
}

