/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.forum;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.param.ForumQueryParam;
import com.bxm.newidea.properties.RecommendProperties;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.vo.ForumRecommend;
import com.bxm.newidea.vo.ForumTopPost;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ForumCommonRecommender
extends AbstractForumRecommender {
    private static final Logger logger = LoggerFactory.getLogger(ForumCommonRecommender.class);
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private RedisListAdapter redisListAdapter;
    @Autowired
    private RecommendProperties recommendProperties;

    public ForumCommonRecommender() {
        super(1.0, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        LinkedList result = Lists.newLinkedList();
        String name = OperationLocationEnum.getName((int)forumParam.getOperationId());
        KeyGenerator readRecordKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)name).appendKey((Object)"already");
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)name).appendKey((Object)"last");
        HashSet readRecordList = Sets.newHashSet();
        String lastRecommendedTime = "";
        if (null == forumParam.getActionType() || 1 == forumParam.getActionType()) {
            this.redisStringAdapter.remove(readRecordKey);
            this.redisStringAdapter.remove(lastRecommendedKey);
            this.getUserTopPost(forumParam, readRecordList, result);
        } else {
            readRecordList.addAll(this.redisSetAdapter.getAllMembers(readRecordKey, Long.class));
            lastRecommendedTime = this.redisStringAdapter.getString(lastRecommendedKey);
        }
        LinkedList<Long> recommendList = this.getRecommendPost(forumParam, readRecordList, readRecordKey);
        int leftNum = forumParam.getPageSize() - result.size() - recommendList.size();
        if (leftNum > 0) {
            ForumQueryParam param = this.getQueryParam(forumParam, lastRecommendedTime);
            List forumPostList = this.forumPostMapper.findForumPostList(param);
            this.recommendedFilter((List<ForumRecommend>)forumPostList, result, readRecordKey, lastRecommendedKey, (Set<Long>)readRecordList, leftNum);
        }
        this.interspersedRecommendPost(recommendList, result);
        return result;
    }

    private void interspersedRecommendPost(LinkedList<Long> recommendPostIds, List<Long> postIds) {
        if (!CollectionUtils.isEmpty(recommendPostIds)) {
            int count = recommendPostIds.size();
            int index = 0;
            for (int i = 0; i < count; ++i) {
                if (index >= postIds.size()) {
                    recommendPostIds.addLast(recommendPostIds.get(i));
                    continue;
                }
                postIds.add(index, recommendPostIds.get(i));
                index += 2;
            }
        }
    }

    private void getUserTopPost(ForumParam forumParam, Set<Long> recommendedIds, LinkedList<Long> result) {
        List forumTopPostList;
        KeyGenerator postUserTopKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)"top");
        Long size = this.redisListAdapter.size(postUserTopKey);
        if (size > 0L && org.apache.commons.collections.CollectionUtils.isNotEmpty(forumTopPostList = this.redisListAdapter.leftIndex(postUserTopKey, size - 1L, ForumTopPost.class).stream().filter(e -> e.getAreaCode().equals(forumParam.getAreaCode())).sorted(Comparator.comparing(ForumTopPost::getDisplayTime).reversed()).collect(Collectors.toList()))) {
            if (forumParam.getOperationId().intValue() == OperationLocationEnum.FORUM_PLATE_NEWEST.getCode()) {
                forumTopPostList = forumTopPostList.stream().filter(e -> Objects.nonNull(e) && Objects.nonNull(e.getForumId()) && e.getForumId().equals(forumParam.getForumId())).collect(Collectors.toList());
            } else if (forumParam.getOperationId().intValue() == OperationLocationEnum.FORUM_TOPIC_NEWEST.getCode()) {
                forumTopPostList = forumTopPostList.stream().filter(e -> Objects.nonNull(e) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)e.getTopicIds()) && e.getTopicIds().contains(forumParam.getTopicId())).collect(Collectors.toList());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(forumTopPostList)) {
                List ids = forumTopPostList.stream().map(ForumTopPost::getId).collect(Collectors.toList());
                recommendedIds.addAll(ids);
                result.addAll(ids);
            }
        }
    }

    private LinkedList<Long> getRecommendPost(ForumParam forumParam, Set<Long> readRecordList, KeyGenerator readRecordKey) {
        LinkedList<Long> result = new LinkedList<Long>();
        if (forumParam.getOperationId().intValue() == OperationLocationEnum.FORUM_HOME_PAGE.getCode()) {
            HashSet recommendRecordList = Sets.newHashSet(readRecordList);
            KeyGenerator dailyRecommendKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)OperationLocationEnum.getName((int)forumParam.getOperationId())).appendKey((Object)DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
            if (!this.redisStringAdapter.hasKey(dailyRecommendKey).booleanValue()) {
                KeyGenerator homeReadRecordKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)OperationLocationEnum.HOME_PAGE.getName()).appendKey((Object)"already");
                recommendRecordList.addAll(this.redisSetAdapter.getAllMembers(homeReadRecordKey, Long.class));
                List forumPostIdList = this.forumPostMapper.findRecommendForumPost(forumParam.getAreaCode(), 100);
                this.recommendedFilter((List<ForumRecommend>)forumPostIdList, result, homeReadRecordKey, readRecordKey, (Set<Long>)recommendRecordList, readRecordList);
                this.redisStringAdapter.set(dailyRecommendKey, (Object)1, 86400L);
            }
        }
        return result;
    }

    private ForumQueryParam getQueryParam(ForumParam forumParam, String lastRecommendedTime) {
        Integer isBrilliant = OperationLocationEnum.FORUM_PLATE_ELITE.getCode() == forumParam.getOperationId().intValue() ? Integer.valueOf(1) : null;
        ForumQueryParam param = new ForumQueryParam();
        param.setAreaCode(forumParam.getAreaCode());
        param.setBrilliant(isBrilliant);
        param.setForumId(forumParam.getForumId());
        param.setLastTime(lastRecommendedTime);
        param.setTopicId(forumParam.getTopicId());
        param.setSize(Integer.valueOf(forumParam.getPageSize() + 50));
        if (forumParam.getOperationId().intValue() == OperationLocationEnum.FORUM_HOME_PAGE.getCode() && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)this.recommendProperties.getFilterForumId())) {
            param.setFilterForumId(this.recommendProperties.getFilterForumId());
        }
        return param;
    }

    private void recommendedFilter(List<ForumRecommend> originList, List<Long> resultList, KeyGenerator homeReadRecordKey, KeyGenerator readRecordKey, Set<Long> recommendReadRecordList, Set<Long> readRecordList) {
        for (ForumRecommend forumRecommend : originList) {
            if (!recommendReadRecordList.contains(forumRecommend.getId())) {
                recommendReadRecordList.add(forumRecommend.getId());
                resultList.add(forumRecommend.getId());
                readRecordList.add(forumRecommend.getId());
            }
            if (resultList.size() < 3) continue;
            break;
        }
        logger.debug("[recommendedFilter]\u5df2\u53d6\u5f97{}\u6761\u4f18\u8d28\u5e16\u5b50\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)resultList.size());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(resultList)) {
            this.redisSetAdapter.add(homeReadRecordKey, resultList.toArray());
            this.redisSetAdapter.expire(homeReadRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            this.redisSetAdapter.add(readRecordKey, resultList.toArray());
            this.redisSetAdapter.expire(readRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }
    }

    private void recommendedFilter(List<ForumRecommend> originList, LinkedList<Long> resultList, KeyGenerator recommendRecordKey, KeyGenerator lastRecommendedKey, Set<Long> readRecordList, int num) {
        Date lastReadTime = null;
        for (ForumRecommend forumRecommend : originList) {
            if (!readRecordList.contains(forumRecommend.getId())) {
                resultList.add(forumRecommend.getId());
                readRecordList.add(forumRecommend.getId());
                lastReadTime = forumRecommend.getDisplayTime();
            }
            if (resultList.size() < num) continue;
            break;
        }
        logger.debug("[recommendedFilter]\u5df2\u53d6\u5f97{}\u6761\u5e16\u5b50\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)resultList.size());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(resultList)) {
            this.redisSetAdapter.add(recommendRecordKey, resultList.toArray());
            this.redisSetAdapter.expire(recommendRecordKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            if (Objects.nonNull(lastReadTime)) {
                this.redisStringAdapter.set(lastRecommendedKey, (Object)DateUtils.formatDateTime((Date)lastReadTime));
                this.redisStringAdapter.expire(lastRecommendedKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            }
        }
    }
}

