/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.forum;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.ForumPostMapper;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.param.ForumQueryParam;
import com.bxm.newidea.recommend.framework.AbstractForumRecommender;
import com.bxm.newidea.util.ObjectUtil;
import com.bxm.newidea.vo.ForumRecommend;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ForumTopicHotRecommender
extends AbstractForumRecommender {
    private static final Logger LOG = LoggerFactory.getLogger(ForumTopicHotRecommender.class);
    @Autowired
    private RedisSetAdapter redisSetAdapter;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private ForumPostMapper forumPostMapper;

    public ForumTopicHotRecommender() {
        super(1.0, 1);
    }

    @Override
    public List<Long> syncRecommend(ForumParam forumParam) {
        Long userId = forumParam.getUserId();
        Integer operationId = forumParam.getOperationId();
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"already");
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)forumParam.getUserId()).appendKey((Object)OperationLocationEnum.getName((int)operationId)).appendKey((Object)"last");
        Set recommendedIds = null;
        Integer lastRecommendedTime = 0;
        if (null == forumParam.getActionType() || 1 == forumParam.getActionType()) {
            this.redisStringAdapter.remove(recommendedKey);
            this.redisStringAdapter.remove(lastRecommendedKey);
        } else {
            recommendedIds = this.redisSetAdapter.getAllMembers(recommendedKey, Long.class);
            lastRecommendedTime = this.redisStringAdapter.getInt(lastRecommendedKey);
        }
        if (null == recommendedIds) {
            recommendedIds = Sets.newHashSet();
        }
        ForumQueryParam param = this.getQueryParam(forumParam, lastRecommendedTime, null, null);
        List forumPostList = this.forumPostMapper.findForumPostList(param);
        ArrayList result = Lists.newArrayList();
        lastRecommendedTime = this.findMoreForumPost(result, forumPostList, recommendedIds, param, 0);
        if (null != lastRecommendedTime) {
            this.redisStringAdapter.set(lastRecommendedKey, (Object)lastRecommendedTime);
        }
        if (null != result && result.size() != 0) {
            Long[] idsArray = new Long[result.size()];
            this.redisSetAdapter.add(recommendedKey, (Object[])result.toArray(idsArray));
        }
        return result;
    }

    private Integer findMoreForumPost(List<Long> result, List<ForumRecommend> forumPostList, Set<Long> recommendedIds, ForumQueryParam param, int count) {
        if (null == forumPostList || forumPostList.size() == 0 || 5 == count) {
            LOG.warn("[forum topic hot]post is none");
            return null;
        }
        int postSize = forumPostList.size();
        Integer lastRecommendedTime = param.getHotScore();
        boolean hasMore = true;
        for (int j = 0; j < postSize; ++j) {
            Long id = ObjectUtil.displayToLong(forumPostList.get(j).getId());
            if (null != id && !recommendedIds.contains(id)) {
                if (!result.contains(id)) {
                    result.add(id);
                } else if (j == postSize - 1) {
                    hasMore = false;
                }
                if (result.size() >= param.getSize()) {
                    return ((ForumRecommend)forumPostList.get(j)).getHotScore();
                }
            }
            lastRecommendedTime = j == postSize - 1 && !hasMore ? null : ((ForumRecommend)forumPostList.get(j)).getHotScore();
        }
        if (result.size() < param.getSize()) {
            if (null == lastRecommendedTime) {
                return param.getHotScore();
            }
            param.setHotScore(lastRecommendedTime);
            forumPostList = this.forumPostMapper.findForumPostList(param);
            return this.findMoreForumPost(result, forumPostList, recommendedIds, param, ++count);
        }
        return lastRecommendedTime;
    }

    private ForumQueryParam getQueryParam(ForumParam forumParam, Integer lastRecommendedTime, Integer isBrilliant, Integer deadline) {
        ForumQueryParam param = new ForumQueryParam();
        param.setAreaCode(forumParam.getAreaCode());
        param.setBrilliant(isBrilliant);
        param.setDeadline(deadline);
        param.setSize(forumParam.getPageSize());
        param.setTopicId(forumParam.getTopicId());
        param.setHot(Integer.valueOf(1));
        param.setHotScore(lastRecommendedTime);
        return param;
    }
}

