/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.mix;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.config.NewsCacheThresholdConfig;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.domain.MixedRecommendPoolMapper;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.recommend.framework.AbstractMixRecommender;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonMixRecommender
extends AbstractMixRecommender {
    @Autowired(required=false)
    public CommonMixRecommender(RedisSetAdapter redisSetAdapter, RedisListAdapter redisListAdapter, RedisStringAdapter redisStringAdapter, MixedRecommendPoolMapper mixedRecommendPoolMapper) {
        super(1.0, 1);
        this.redisSetAdapter = redisSetAdapter;
        this.redisListAdapter = redisListAdapter;
        this.redisStringAdapter = redisStringAdapter;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
    }

    @Override
    protected List<MixRecomendResult> syncRecommend(Long userId, Integer actionType, Integer num, String areaCode) {
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.HOME_PAGE.getName()).appendKey((Object)"already");
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.HOME_PAGE.getName()).appendKey((Object)"last");
        ArrayList result = Lists.newArrayList();
        Set recommendedIds = Sets.newHashSet();
        Integer lastRecommendedWeight = null;
        if (1 == actionType) {
            this.redisStringAdapter.remove(recommendedKey);
            this.redisStringAdapter.remove(lastRecommendedKey);
        } else {
            recommendedIds = this.redisSetAdapter.getAllMembers(recommendedKey, Long.class);
            lastRecommendedWeight = this.redisStringAdapter.getInt(lastRecommendedKey);
        }
        List originList = this.mixedRecommendPoolMapper.selectLastRecommendList(lastRecommendedWeight, areaCode, Integer.valueOf(1000));
        this.recommendedFilter(originList, result, recommendedKey, lastRecommendedKey, recommendedIds, num);
        return result;
    }

    private void recommendedFilter(List<MixRecomendResult> originList, List<MixRecomendResult> resultList, KeyGenerator recommendedKey, KeyGenerator lastRecommendedKey, Set<Long> record, int num) {
        for (MixRecomendResult mixRecomendResult : originList) {
            this.generateResult(record, mixRecomendResult, resultList);
            if (resultList.size() < num) continue;
            this.logger.info("[recommendedFilter]\u5df2\u53d6\u5f97{}\u6761\u6df7\u5408\u63a8\u8350\u6570\u636e\uff0c\u529f\u6210\u5706\u6ee1", (Object)num);
            break;
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            this.redisSetAdapter.add(recommendedKey, (Object[])resultList.stream().map(MixRecomendResult::getId).toArray(Long[]::new));
            this.redisSetAdapter.expire(recommendedKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
            this.redisStringAdapter.set(lastRecommendedKey, (Object)resultList.get(resultList.size() - 1).getWeight());
            this.redisStringAdapter.expire(lastRecommendedKey, (long)NewsCacheThresholdConfig.MIX_EXPIRE_RECOMMENDED_RECORD);
        }
    }

    private void generateResult(Set<Long> record, MixRecomendResult mixRecomendResult, List<MixRecomendResult> resultList) {
        if (!record.contains(mixRecomendResult.getId())) {
            MixRecomendResult mixRecomendResultCopy = new MixRecomendResult(mixRecomendResult.getId(), mixRecomendResult.getOrigin(), mixRecomendResult.getWeight());
            resultList.add(mixRecomendResultCopy);
            record.add(mixRecomendResultCopy.getId());
        }
    }
}

