/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.recommend.handler.news;

import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.domain.NewsPoolMapper;
import com.bxm.newidea.enums.NewsKindEnum;
import com.bxm.newidea.integration.NewsSyncIntegrationService;
import com.bxm.newidea.recommend.framework.AbstractNewsRecommender;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class EmergencyNewsRecommender
extends AbstractNewsRecommender {
    private NewsPoolMapper newsPoolMapper;

    @Autowired(required=false)
    public EmergencyNewsRecommender(NewsPoolMapper newsPoolMapper, RedisListAdapter redisListAdapter, NewsSyncIntegrationService newsSyncIntegrationService) {
        super(1.0, 99);
        this.newsPoolMapper = newsPoolMapper;
        this.redisListAdapter = redisListAdapter;
        this.newsSyncIntegrationService = newsSyncIntegrationService;
    }

    @Override
    protected List<Long> syncRecommend(Long userId, Integer kindId, Integer num, String areaCode) {
        ArrayList<Long> result = new ArrayList<Long>();
        List<Long> originList = this.listEmergencyNews(userId, kindId, num);
        if (!CollectionUtils.isEmpty(originList)) {
            this.recommendedFilter(originList, num, result, userId);
        }
        return result;
    }

    private List<Long> listEmergencyNews(Long userId, Integer kindId, Integer num) {
        List originList = kindId == null ? this.newsPoolMapper.recommendNews(userId, Long.valueOf(NewsKindEnum.RECOMMEND.getCode().intValue()), Integer.valueOf(1), null, Integer.valueOf(num + 5)) : this.newsPoolMapper.recommendNews(userId, Long.valueOf(kindId.intValue()), Integer.valueOf(1), null, Integer.valueOf(num + 5));
        return originList;
    }

    @Override
    protected void asyncRecommend(Long userId, Integer kindId, String areaCode) {
    }
}

