/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.param.ForumParam;
import com.bxm.newidea.recommend.engine.ForumRecommendEngine;
import com.bxm.newidea.service.ForumService;
import com.bxm.newidea.vo.CircleNode;
import com.bxm.newidea.vo.ForumTopPost;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ForumServiceImpl
extends BaseService
implements ForumService {
    private static final Logger LOG = LoggerFactory.getLogger(ForumServiceImpl.class);
    @Autowired
    private ForumRecommendEngine forumRecommendEngine;
    @Autowired
    private RedisListAdapter redisListAdapter;

    @Override
    public List<Long> recommend(ForumParam forumParam) {
        String msg = this.checkParam(forumParam);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            LOG.error("[forum recommend service] parameter error:{}", (Object)msg);
            return new ArrayList<Long>();
        }
        if (null == forumParam.getPageSize()) {
            forumParam.setPageSize(Integer.valueOf(10));
        }
        return this.forumRecommendEngine.recommend(forumParam);
    }

    @Override
    public void cleanUserTop(Long userId, Long postId) {
        if (null == userId) {
            return;
        }
        KeyGenerator postUserTop = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)"top");
        Long size = this.redisListAdapter.size(postUserTop);
        if (size == 0L) {
            return;
        }
        List forumTopPostList = this.redisListAdapter.leftIndex(postUserTop, size - 1L, ForumTopPost.class);
        this.logger.debug("[cleanUserTop] \u5f97\u5230\u7528\u6237\u5728\u4e00\u4e2a\u5c0f\u65f6\u4ee5\u5185\u53d1\u7684\u5e16\u5b50:{}", (Object)JSONObject.toJSONString((Object)forumTopPostList));
        forumTopPostList.removeIf(e -> postId.equals(e.getId()));
        this.redisListAdapter.remove(postUserTop);
        this.logger.debug("[cleanUserTop] \u53d6\u6d88\u7528\u6237\u88ab\u5ba1\u6838\u62d2\u7edd\u7684\u5e16\u5b50\u7f6e\u9876:{}", (Object)JSONObject.toJSONString((Object)forumTopPostList));
        this.redisListAdapter.rightPush(postUserTop, (Object[])forumTopPostList.toArray(new ForumTopPost[0]));
    }

    @Override
    public CircleNode[] getCircleNode(List<Long> idList) {
        int length = idList.size();
        CircleNode[] circleNodes = new CircleNode[length];
        int i = 0;
        for (Long id : idList) {
            circleNodes[i] = new CircleNode();
            circleNodes[i].setId(id.longValue());
            circleNodes[i].setNext(i + 1);
            ++i;
        }
        circleNodes[length - 1].setNext(0);
        return circleNodes;
    }

    private String checkParam(ForumParam forumParam) {
        Integer operationId = forumParam.getOperationId();
        StringBuffer sb = new StringBuffer();
        if (null == forumParam.getUserId()) {
            sb.append("\u7528\u6237id\u4e3a\u7a7a").append(",");
        }
        if (null == operationId) {
            sb.append("\u8fd0\u8425\u4f4did\u4e3a\u7a7a").append(",");
        }
        if (StringUtils.isBlank((CharSequence)forumParam.getAreaCode())) {
            sb.append("\u533a\u57df\u7f16\u7801\u4e3a\u7a7a").append(",");
        }
        if (null != operationId && OperationLocationEnum.FORUM_POST_DETAIL.getCode() == operationId.intValue()) {
            if (null == forumParam.getPostId()) {
                sb.append("\u5e16\u5b50id\u4e3a\u7a7a").append(",");
            }
        } else {
            if (null == forumParam.getActionType()) {
                sb.append("\u884c\u4e3a\u6807\u8bb0\u4e3a\u7a7a").append(",");
            }
            if (null != operationId && null == forumParam.getForumId() && (OperationLocationEnum.FORUM_PLATE_ELITE.getCode() == operationId.intValue() || OperationLocationEnum.FORUM_PLATE_NEWEST.getCode() == operationId.intValue())) {
                sb.append("\u677f\u5757id\u4e3a\u7a7a").append(",");
            }
            if (null != operationId && null == forumParam.getTopicId() && (OperationLocationEnum.FORUM_TOPIC_HOT.getCode() == operationId.intValue() || OperationLocationEnum.FORUM_TOPIC_NEWEST.getCode() == operationId.intValue())) {
                sb.append("\u8bdd\u9898id\u4e3a\u7a7a").append(",");
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

