/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.service.impl;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.constant.RedisKeyConstant;
import com.bxm.newidea.dto.MixRecomendResult;
import com.bxm.newidea.enums.OperationLocationEnum;
import com.bxm.newidea.service.MixRecommendService;
import com.bxm.newidea.vo.CircleNode;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MixRecommendServiceImpl
extends BaseService
implements MixRecommendService {
    @Autowired
    private RedisListAdapter redisListAdapter;
    @Autowired
    private RedisStringAdapter redisStringAdapter;
    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Override
    public void cleanMixCache(Long userId) {
        this.logger.debug("[cleanMixCache]\u5220\u9664\u6df7\u5408\u63a8\u8350\u7f13\u5b58\uff0c\u7528\u6237id:{}", (Object)userId);
        KeyGenerator mixLastReadTime = RedisKeyConstant.MIX_LAST_READ_TIME.copy().appendKey((Object)userId);
        KeyGenerator mixFixIndex = RedisKeyConstant.MIX_FIX_INDEX.copy().appendKey((Object)userId);
        KeyGenerator mixRecentlyPool = RedisKeyConstant.MIX_RECENTLY_POOL.copy().appendKey((Object)userId);
        KeyGenerator mixRecommendBrowsing = RedisKeyConstant.MIX_RECOMMENDED.copy().appendKey((Object)userId);
        KeyGenerator recommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.getName((int)2)).appendKey((Object)"browsingKey");
        KeyGenerator lastRecommendedKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.getName((int)2)).appendKey((Object)"lastreadtime");
        KeyGenerator forumPostPoolKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.getName((int)2)).appendKey((Object)"recentlypool");
        KeyGenerator indexKeyindexKey = RedisKeyConstant.FORUM_RECOMMENDED.copy().appendKey((Object)userId).appendKey((Object)OperationLocationEnum.getName((int)2)).appendKey((Object)"index");
        this.redisSetAdapter.remove(recommendedKey);
        this.redisStringAdapter.remove(lastRecommendedKey);
        this.redisListAdapter.remove(forumPostPoolKey);
        this.redisStringAdapter.remove(indexKeyindexKey);
        this.redisStringAdapter.remove(mixLastReadTime);
        this.redisListAdapter.remove(mixRecentlyPool);
        this.redisStringAdapter.remove(mixFixIndex);
        this.redisSetAdapter.remove(mixRecommendBrowsing);
    }

    @Override
    public CircleNode[] getCircleNode(List<MixRecomendResult> mixRecommendResultList) {
        int length = mixRecommendResultList.size();
        CircleNode[] circleNodes = new CircleNode[length];
        int i = 0;
        for (MixRecomendResult mixRecomendResult : mixRecommendResultList) {
            circleNodes[i] = new CircleNode();
            circleNodes[i].setId(mixRecomendResult.getId().longValue());
            circleNodes[i].setOrigin(mixRecomendResult.getOrigin());
            circleNodes[i].setNext(i + 1);
            ++i;
        }
        circleNodes[length - 1].setNext(0);
        return circleNodes;
    }
}

