package com.bxm.localnews.facade.controller;

import com.bxm.localnews.model.dto.NewsDetailWarper;
import com.bxm.localnews.model.param.NewsParam;
import com.bxm.localnews.model.vo.News;
import com.bxm.localnews.service.NewsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;


@Api(tags = "1-01 搜索引擎新闻接口", description = "对新闻进行相关的操作")
@RestController
@RequestMapping("api/news/search")
public class ElasticSearchController {

    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchController.class);

    private final NewsService newsService;

    @Autowired
    public ElasticSearchController(NewsService newsService) {
        this.newsService = newsService;
    }

    @ApiOperation(value = "1-01-01 根据关键词全文检索新闻内容及标题", notes = "用户输入关键字后进行分词全文检索新闻内容及标题,按匹配度排序", httpMethod = "POST")
    @PostMapping("")
    public ResponseEntity<List<News>> search(@RequestParam(value = "keyword") String keyword,
                                             @RequestParam(value = "pageNum", defaultValue = "0") int pageIndex,
                                             @RequestParam(value = "pageSize", defaultValue = "10") int pageSize) {
        return new ResponseEntity<>(newsService.selectNews(keyword, pageIndex, pageSize), HttpStatus.OK);
    }

    @ApiOperation(value = "1-01-02 根据id查找新闻内容", notes = "根据id列表地查找新闻详情内容", httpMethod = "GET")
    @ApiImplicitParams({

    })
    @GetMapping(value = "/get")
    public ResponseEntity<List<NewsDetailWarper>> get(@RequestParam List<Long> ids) {
        return new ResponseEntity<>(newsService.listNewsDetail(ids), HttpStatus.OK);
    }

    @ApiOperation(value = "1-01-03 新增或者更新数据", notes = "把数据插入或更新", httpMethod = "POST")
    @ApiImplicitParams({
    })
    @PostMapping(value = "/sync")
    public ResponseEntity save(@RequestBody NewsParam newsParam) {
        newsService.save(newsParam);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @ApiOperation(value = "1-01-04 批量删除数据", notes = "批量删除数据", httpMethod = "DELETE")
    @ApiImplicitParams({
    })
    @DeleteMapping(value = "/sync")
    public ResponseEntity del(@RequestParam List<Long> ids) {
        newsService.batchDelNews(ids);
        return new ResponseEntity<>(HttpStatus.OK);
    }

    @ApiOperation(value = "1-01-05 批量新增或者更新数据", notes = "批量把数据插入或更新", httpMethod = "POST")
    @ApiImplicitParams({
    })
    @PostMapping(value = "/sync/batch")
    public ResponseEntity saveBatch(@RequestBody List<NewsParam> newsParamList) {
        LOGGER.debug("start batch sync");
        newsService.batchSave(newsParamList);
        LOGGER.debug("finish batch sync");
        return new ResponseEntity<>(HttpStatus.OK);
    }
}
