/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.facade.controller;

import com.bxm.localnews.model.dto.NewsDetailWarper;
import com.bxm.localnews.model.param.NewsParam;
import com.bxm.localnews.model.vo.News;
import com.bxm.localnews.service.NewsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-01 \u641c\u7d22\u5f15\u64ce\u65b0\u95fb\u63a5\u53e3"}, description="\u5bf9\u65b0\u95fb\u8fdb\u884c\u76f8\u5173\u7684\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/news/search"})
public class ElasticSearchController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticSearchController.class);
    private final NewsService newsService;

    @Autowired
    public ElasticSearchController(NewsService newsService) {
        this.newsService = newsService;
    }

    @ApiOperation(value="1-01-01 \u6839\u636e\u5173\u952e\u8bcd\u5168\u6587\u68c0\u7d22\u65b0\u95fb\u5185\u5bb9\u53ca\u6807\u9898", notes="\u7528\u6237\u8f93\u5165\u5173\u952e\u5b57\u540e\u8fdb\u884c\u5206\u8bcd\u5168\u6587\u68c0\u7d22\u65b0\u95fb\u5185\u5bb9\u53ca\u6807\u9898,\u6309\u5339\u914d\u5ea6\u6392\u5e8f", httpMethod="POST")
    @PostMapping(value={""})
    public ResponseEntity<List<News>> search(@RequestParam(value="keyword") String keyword, @RequestParam(value="pageNum", defaultValue="0") int pageIndex, @RequestParam(value="pageSize", defaultValue="10") int pageSize) {
        return new ResponseEntity((Object)this.newsService.selectNews(keyword, pageIndex, pageSize), HttpStatus.OK);
    }

    @ApiOperation(value="1-01-02 \u6839\u636eid\u67e5\u627e\u65b0\u95fb\u5185\u5bb9", notes="\u6839\u636eid\u5217\u8868\u5730\u67e5\u627e\u65b0\u95fb\u8be6\u60c5\u5185\u5bb9", httpMethod="GET")
    @ApiImplicitParams(value={})
    @GetMapping(value={"/get"})
    public ResponseEntity<List<NewsDetailWarper>> get(@RequestParam List<Long> ids) {
        return new ResponseEntity((Object)this.newsService.listNewsDetail(ids), HttpStatus.OK);
    }

    @ApiOperation(value="1-01-03 \u65b0\u589e\u6216\u8005\u66f4\u65b0\u6570\u636e", notes="\u628a\u6570\u636e\u63d2\u5165\u6216\u66f4\u65b0", httpMethod="POST")
    @ApiImplicitParams(value={})
    @PostMapping(value={"/sync"})
    public ResponseEntity save(@RequestBody NewsParam newsParam) {
        this.newsService.save(newsParam);
        return new ResponseEntity(HttpStatus.OK);
    }

    @ApiOperation(value="1-01-04 \u6279\u91cf\u5220\u9664\u6570\u636e", notes="\u6279\u91cf\u5220\u9664\u6570\u636e", httpMethod="DELETE")
    @ApiImplicitParams(value={})
    @DeleteMapping(value={"/sync"})
    public ResponseEntity del(@RequestParam List<Long> ids) {
        this.newsService.batchDelNews(ids);
        return new ResponseEntity(HttpStatus.OK);
    }

    @ApiOperation(value="1-01-05 \u6279\u91cf\u65b0\u589e\u6216\u8005\u66f4\u65b0\u6570\u636e", notes="\u6279\u91cf\u628a\u6570\u636e\u63d2\u5165\u6216\u66f4\u65b0", httpMethod="POST")
    @ApiImplicitParams(value={})
    @PostMapping(value={"/sync/batch"})
    public ResponseEntity saveBatch(@RequestBody List<NewsParam> newsParamList) {
        LOGGER.debug("start batch sync");
        this.newsService.batchSave(newsParamList);
        LOGGER.debug("finish batch sync");
        return new ResponseEntity(HttpStatus.OK);
    }
}

