/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.facade.controller;

import com.bxm.localnews.model.param.AdminNewsPageParam;
import com.bxm.localnews.model.param.NewsParam;
import com.bxm.localnews.model.vo.AdminNews;
import com.bxm.localnews.model.vo.News;
import com.bxm.localnews.model.vo.NewsDetail;
import com.bxm.localnews.service.NewsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"1-01 \u641c\u7d22\u5f15\u64ce\u65b0\u95fb\u63a5\u53e3"}, description="\u5bf9\u65b0\u95fb\u8fdb\u884c\u76f8\u5173\u7684\u64cd\u4f5c")
@RestController
@RequestMapping(value={"api/news/search"})
public class ElasticSearchController {
    private final NewsService newsService;

    @Autowired
    public ElasticSearchController(NewsService newsService) {
        this.newsService = newsService;
    }

    @ApiOperation(value="1-01-01 \u6839\u636e\u5173\u952e\u8bcd\u5168\u6587\u68c0\u7d22", notes="[\u8fd0\u8425\u540e\u53f0]\u7528\u6237\u8f93\u5165\u5173\u952e\u5b57\u540e\u8fdb\u884c\u5206\u8bcd\u5168\u6587\u68c0\u7d22\u65b0\u95fb\u5185\u5bb9\u53ca\u6807\u9898,\u6309\u5339\u914d\u5ea6\u6392\u5e8f", httpMethod="POST")
    @PostMapping(value={""})
    public ResponseEntity<AdminNews> search(@RequestBody AdminNewsPageParam adminNewsPageParam) {
        adminNewsPageParam.setPageNum(Integer.valueOf(adminNewsPageParam.getPageNum() - 1));
        return new ResponseEntity((Object)this.newsService.selectNews(adminNewsPageParam), HttpStatus.OK);
    }

    @ApiOperation(value="1-01-02 \u6839\u636eid\u67e5\u627e\u65b0\u95fb\u5185\u5bb9(\u5305\u62ec\u5185\u5bb9)", notes="\u6839\u636eid\u5217\u8868\u5730\u67e5\u627e\u65b0\u95fb\u8be6\u60c5\u5185\u5bb9", httpMethod="GET")
    @GetMapping(value={"/get"})
    public ResponseEntity<List<NewsDetail>> get(@RequestParam List<Long> ids) {
        return new ResponseEntity((Object)this.newsService.listNewsDetail(ids), HttpStatus.OK);
    }

    @ApiOperation(value="1-01-03 \u65b0\u589e\u6216\u8005\u66f4\u65b0\u6570\u636e", notes="\u628a\u6570\u636e\u63d2\u5165\u6216\u66f4\u65b0", httpMethod="POST")
    @ApiImplicitParams(value={})
    @PostMapping(value={"/sync"})
    public ResponseEntity save(@RequestBody NewsParam newsParam) {
        this.newsService.save(newsParam);
        return new ResponseEntity(HttpStatus.OK);
    }

    @ApiOperation(value="1-01-04 \u6279\u91cf\u5220\u9664\u6570\u636e", notes="\u6279\u91cf\u5220\u9664\u6570\u636e", httpMethod="DELETE")
    @ApiImplicitParams(value={})
    @DeleteMapping(value={"/sync"})
    public ResponseEntity del(@RequestParam List<Long> ids) {
        this.newsService.batchDelNews(ids);
        return new ResponseEntity(HttpStatus.OK);
    }

    @ApiOperation(value="1-01-05 \u6279\u91cf\u65b0\u589e\u6216\u8005\u66f4\u65b0\u6570\u636e", notes="\u6279\u91cf\u628a\u6570\u636e\u63d2\u5165\u6216\u66f4\u65b0", httpMethod="POST")
    @ApiImplicitParams(value={})
    @PostMapping(value={"/sync/batch"})
    public ResponseEntity saveBatch(@RequestBody List<NewsParam> newsParamList) {
        this.newsService.batchSave(newsParamList);
        return new ResponseEntity(HttpStatus.OK);
    }

    @ApiOperation(value="1-01-06 \u6839\u636eids\u67e5\u627e\u65b0\u95fb\u6982\u89c8\u4fe1\u606f(\u4e0d\u5305\u62ec\u5185\u5bb9)", notes="\u6839\u636eids\u67e5\u627e\u65b0\u95fb\u6982\u89c8\u4fe1\u606f(\u4e0d\u5305\u62ec\u5185\u5bb9)", httpMethod="GET")
    @GetMapping(value={"/list"})
    public ResponseEntity<List<News>> listNews(@RequestParam List<Long> ids) {
        return new ResponseEntity((Object)this.newsService.listNews(ids), HttpStatus.OK);
    }

    @ApiOperation(value="1-01-08 \u67e5\u770b\u7f6e\u9876\u65b0\u95fb", notes="\u67e5\u770b\u7f6e\u9876\u65b0\u95fb", httpMethod="GET")
    @GetMapping(value={"/top"})
    public ResponseEntity<List<News>> listTopNews(@RequestParam Integer size, @RequestParam(value="areaCode", required=false) String areaCode) {
        return new ResponseEntity((Object)this.newsService.listTopNews(size.intValue(), areaCode), HttpStatus.OK);
    }
}

