package com.bxm.localnews.model.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.Setting;

import java.util.Date;

@ApiModel("新闻实体")
@Mapping(mappingPath = "elasticsearch/news_mapping.json")
@Setting(settingPath = "elasticsearch/news_setting.json")
@Document(indexName = "localnews-news",type = "news",indexStoreType="fs",shards=5,replicas=1,refreshInterval="-1")
public class NewsWarper {

    @Id
    private  String id;

    private  String title;

    private Date issueTime;

    private String author;

    private String imgUrl;

    private Integer kindId;

    private Date addTime;

    private Byte top;

    private Byte type;

    private Byte isRecommend;

    private Byte hot;

    private String[] areaDetail;

    private Integer reviewStatus;

    private Date modifyTime;

    private Integer kindTop;

    private Date publishTime;

    private Integer comments;

    private Integer views;

    private Integer status;

    @ApiModelProperty("是否强引导下载  0:否 1:是")
    private Byte isBootDownload=0;

    public NewsWarper(){
    }

    @JsonProperty("imgUrl")
    public String getImgUrl() {
        return imgUrl;
    }

    @JsonProperty("img_url")
    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Integer getComments() {
        return comments;
    }

    public void setComments(Integer comments) {
        this.comments = comments;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty("issueTime")
    public Date getIssueTime() {
        return issueTime;
    }

    @JsonProperty("issue_time")
    public void setIssueTime(Date issueTime) {
        this.issueTime = issueTime;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @JsonProperty("kindId")
    public Integer getKindId() {
        return kindId;
    }

    @JsonProperty("kind_id")
    public void setKindId(Integer kindId) {
        this.kindId = kindId;
    }

    @JsonProperty("addTime")
    public Date getAddTime() {
        return addTime;
    }

    @JsonProperty("add_time")
    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Byte getTop() {
        return top;
    }

    public void setTop(Byte top) {
        this.top = top;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Byte getHot() {
        return hot;
    }

    public void setHot(Byte hot) {
        this.hot = hot;
    }

    @JsonProperty("areaDetail")
    public String[] getAreaDetail() {
        return areaDetail;
    }

    @JsonProperty("area_detail")
    public void setAreaDetail(String[] areaDetail) {
        this.areaDetail = areaDetail;
    }

    @JsonProperty("reviewStatus")
    public Integer getReviewStatus() {
        return reviewStatus;
    }

    @JsonProperty("review_status")
    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    @JsonProperty("modifyTime")
    public Date getModifyTime() {
        return modifyTime;
    }

    @JsonProperty("modify_time")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @JsonProperty("kindTop")
    public Integer getKindTop() {
        return kindTop;
    }

    @JsonProperty("kind_top")
    public void setKindTop(Integer kindTop) {
        this.kindTop = kindTop;
    }

    @JsonProperty("publishTime")
    public Date getPublishTime() {
        return publishTime;
    }

    @JsonProperty("publish_time")
    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getViews() {
        return views;
    }

    public void setViews(Integer views) {
        this.views = views;
    }

    @JsonProperty("isRecommend")
    public Byte getIsRecommend() {
        return isRecommend;
    }

    @JsonProperty("is_recommend")
    public void setIsRecommend(Byte isRecommend) {
        this.isRecommend = isRecommend;
    }

    @JsonProperty("isBootDownload")
    public Byte getIsBootDownload() {
        return isBootDownload;
    }
    @JsonProperty("is_boot_download")
    public void setIsBootDownload(Byte isBootDownload) {
        this.isBootDownload = isBootDownload;
    }
}
