package com.bxm.localnews.model.param;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel("新闻查询实体")
public class AdminNewsPageParam extends PageParam {

    private Long id;

    @ApiModelProperty("新闻标题")
    private String keyword;

    @ApiModelProperty("区域信息")
    private String areaCode;

    @ApiModelProperty("来源信息")
    private String author;

    @ApiModelProperty("标签详情 0：置顶 1：热 2：频道置顶 3：活动 4：本地 99：普通信息流")
    private Integer showLevel;

    @ApiModelProperty("状态")
    private Integer status;

    @ApiModelProperty("频道编号")
    private Integer kindId;

    @ApiModelProperty("审核状态")
    private Integer reviewStatus;

    @ApiModelProperty(value = "发布区域类型0全国 1地方",required = true)
    private Integer deliveryType;

    @ApiModelProperty("推荐状态 是否推荐 0:否  1是")
    private Byte isRecommend;

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Byte getIsRecommend() {
        return isRecommend;
    }

    public void setIsRecommend(Byte isRecommend) {
        this.isRecommend = isRecommend;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public String getKeyword() {
        return keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public Integer getShowLevel() {
        return showLevel;
    }

    public void setShowLevel(Integer showLevel) {
        this.showLevel = showLevel;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getKindId() {
        return kindId;
    }

    public void setKindId(Integer kindId) {
        this.kindId = kindId;
    }

    public Integer getReviewStatus() {
        return reviewStatus;
    }

    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
