package com.bxm.localnews.model.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.Setting;

import java.io.Serializable;
import java.util.Date;

/**
 * 新闻实体
 * 字段名即英文名直译，不写注释了
 */
@Mapping(mappingPath = "elasticsearch/news_mapping.json")
@Setting(settingPath = "elasticsearch/news_setting.json")
@Document(indexName = "localnews-news", type = "news", indexStoreType = "fs", shards = 5, replicas = 1, refreshInterval = "-1")
public class News implements Serializable {

    @Id
    private String id;

    private String title;

    private String author;

    private String coverList;

    private String imgUrl;

    private Integer kindId;

    private Byte type;

    private Byte top;

    private Integer kindTop;

    private Byte hot;

    private Integer reviewStatus;

    private Date addTime;

    private Date issueTime;

    private Date modifyTime;

    private Date topExpireTime;

    private Date hotExpireTime;

    private Date publishTime;

    private Integer comments;

    private Integer shares;

    private Integer views;

    private Integer status;

    private String areaDetail;

    private String videoList;

    @ApiModelProperty("封面选择,默认值:0")
    private Byte coverSelect = 0;

    @ApiModelProperty("启用占位符")
    private Byte enablePlaceholder;

    @ApiModelProperty("是否强引导下载  0:否 1:是")
    private Byte isBootDownload = 0;

    public News() {
    }

    @JsonProperty("enablePlaceholder")
    public Byte getEnablePlaceholder() {
        return enablePlaceholder;
    }

    @JsonProperty("enable_placeholder")
    public void setEnablePlaceholder(Byte enablePlaceholder) {
        this.enablePlaceholder = enablePlaceholder;
    }

    @JsonProperty("areaDetail")
    public String getAreaDetail() {
        return areaDetail;
    }

    @JsonProperty("area_detail")
    public void setAreaDetail(String[] areaDetail) {
        if (areaDetail != null) {
            this.areaDetail = String.join(",", areaDetail);
        }
    }

    @JsonProperty("imgUrl")
    public String getImgUrl() {
        return imgUrl;
    }

    @JsonProperty("img_url")
    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Integer getComments() {
        return comments;
    }

    public void setComments(Integer comments) {
        this.comments = comments;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty("issueTime")
    public Date getIssueTime() {
        return issueTime;
    }

    @JsonProperty("issue_time")
    public void setIssueTime(Date issueTime) {
        this.issueTime = issueTime;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @JsonProperty("kindId")
    public Integer getKindId() {
        return kindId;
    }

    @JsonProperty("kind_id")
    public void setKindId(Integer kindId) {
        this.kindId = kindId;
    }

    @JsonProperty("addTime")
    public Date getAddTime() {
        return addTime;
    }

    @JsonProperty("add_time")
    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public Byte getTop() {
        return top;
    }

    public void setTop(Byte top) {
        this.top = top;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public Byte getHot() {
        return hot;
    }

    public void setHot(Byte hot) {
        this.hot = hot;
    }

    @JsonProperty("reviewStatus")
    public Integer getReviewStatus() {
        return reviewStatus;
    }

    @JsonProperty("review_status")
    public void setReviewStatus(Integer reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    @JsonProperty("modifyTime")
    public Date getModifyTime() {
        return modifyTime;
    }

    @JsonProperty("modify_time")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @JsonProperty("kindTop")
    public Integer getKindTop() {
        return kindTop;
    }

    @JsonProperty("kind_top")
    public void setKindTop(Integer kindTop) {
        this.kindTop = kindTop;
    }

    @JsonProperty("publishTime")
    public Date getPublishTime() {
        return publishTime;
    }

    @JsonProperty("publish_time")
    public void setPublishTime(Date publishTime) {
        this.publishTime = publishTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getViews() {
        return views;
    }

    public void setViews(Integer views) {
        this.views = views;
    }

    @JsonProperty("topExpireTime")
    public Date getTopExpireTime() {
        return topExpireTime;
    }

    @JsonProperty("top_expire_time")
    public News setTopExpireTime(Date topExpireTime) {
        this.topExpireTime = topExpireTime;
        return this;
    }

    @JsonProperty("hotExpireTime")
    public Date getHotExpireTime() {
        return hotExpireTime;
    }

    @JsonProperty("hot_expire_time")
    public News setHotExpireTime(Date hotExpireTime) {
        this.hotExpireTime = hotExpireTime;
        return this;
    }

    @JsonProperty("isBootDownload")
    public Byte getIsBootDownload() {
        return isBootDownload;
    }

    @JsonProperty("is_boot_download")
    public void setIsBootDownload(Byte isBootDownload) {
        this.isBootDownload = isBootDownload;
    }

    @JsonProperty("coverList")
    public String getCoverList() {
        return coverList;
    }

    @JsonProperty("cover_list")
    public void setCoverList(String coverList) {
        this.coverList = coverList;
    }

    @JsonProperty("videoStr")
    public String getVideoList() {
        return videoList;
    }

    @JsonProperty("video_list")
    public void setVideoList(String videoList) {
        this.videoList = videoList;
    }

    public Integer getShares() {
        return shares;
    }

    public void setShares(Integer shares) {
        this.shares = shares;
    }

    @JsonProperty("coverSelect")
    public Byte getCoverSelect() {
        return coverSelect;
    }

    @JsonProperty("cover_select")
    public void setCoverSelect(Byte coverSelect) {
        this.coverSelect = coverSelect;
    }
}
