package com.bxm.localnews.model.vo;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.Setting;

@Mapping(mappingPath = "elasticsearch/news_mapping.json")
@Setting(settingPath = "elasticsearch/news_setting.json")
@Document(indexName = "localnews-news",type = "news",indexStoreType="fs",shards=5,replicas=1,refreshInterval="-1")
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class NewsDetail extends News{

    private String content;

    private String editorMessage;

    private Long editorMessageId;

    @JsonProperty("editorMessage")
    public String getEditorMessage() {
        return editorMessage;
    }

    @JsonProperty("editor_message")
    public void setEditorMessage(String editorMessage) {
        this.editorMessage = editorMessage;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @JsonProperty("editorMessageId")
    public Long getEditorMessageId() {
        return editorMessageId;
    }

    @JsonProperty("editor_message_id")
    public void setEditorMessageId(Long editorMessageId) {
        this.editorMessageId = editorMessageId;
    }
}
