package com.bxm.localnews.model.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.Setting;


@ApiModel("新闻详细信息实体【旧】")
@Mapping(mappingPath = "elasticsearch/news_mapping.json")
@Setting(settingPath = "elasticsearch/news_setting.json")
@Document(indexName = "localnews",type = "news",indexStoreType="fs",shards=5,replicas=1,refreshInterval="-1")
public class OldNews {

    @ApiModelProperty("新闻id")
    private Long id;

    @ApiModelProperty("新闻标题")
    private String title;

    @ApiModelProperty("新闻内容")
    private String content;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}
