/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.utils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class ChineseToPinYinUtil {
    public static void main(String[] args) {
        System.out.println(ChineseToPinYinUtil.ToFirstChar("\u6c49\u5b57ddddd\u8f6c\u6362\u4e3a\u62fc\u97f3").toLowerCase());
        System.out.println(ChineseToPinYinUtil.ToPinyin("\u6c49\u5b57\u8f6c\u6362\u4e3a\u62fc\u97f3"));
        System.out.println(ChineseToPinYinUtil.getStartChineseString("\u6c49\u5b57\u58f9ddddd\u8f6c\u6362\u4e3a\u62fc\u97f3"));
    }

    public static String ToFirstChar(String chinese) {
        String pinyinStr = "";
        char[] newChar = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < newChar.length; ++i) {
            if (newChar[i] > '\u0080') {
                try {
                    pinyinStr = pinyinStr + PinyinHelper.toHanyuPinyinStringArray((char)newChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0].charAt(0);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pinyinStr = pinyinStr + newChar[i];
        }
        return pinyinStr;
    }

    public static String ToPinyin(String chinese) {
        String pinyinStr = "";
        char[] newChar = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < newChar.length; ++i) {
            if (newChar[i] > '\u0080') {
                try {
                    pinyinStr = pinyinStr + PinyinHelper.toHanyuPinyinStringArray((char)newChar[i], (HanyuPinyinOutputFormat)defaultFormat)[0];
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pinyinStr = pinyinStr + newChar[i];
        }
        return pinyinStr;
    }

    public static String getStartChineseString(String key) {
        char[] ch = key.toCharArray();
        StringBuilder chinese = new StringBuilder();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            System.out.println(c + " --> " + (ChineseToPinYinUtil.isChinese(c) ? "\u662f" : "\u5426"));
            if (!ChineseToPinYinUtil.isChinese(c)) break;
            chinese.append(c);
        }
        return chinese.toString();
    }

    public static boolean isChineseString(String key) {
        char[] ch = key.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            System.out.println(c + " --> " + (ChineseToPinYinUtil.isChinese(c) ? "\u662f" : "\u5426"));
            if (ChineseToPinYinUtil.isChinese(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }
}

