package com.bxm.localnews.sync.primary.dao;



import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

@Mapper
public interface NewsInfoSyncMapper {
    /**
     * 同步新闻评论数
     * @param tableName
     * @return
     */
    int syncNewsComment(@Param("tableName") String  tableName );
    /**
     * 同步新闻分享数
     * @param tableName
     * @return
     */
    int syncAccumulateNewsShares(@Param("tableName") String  tableName );
    /**
     * 同步新闻收藏数
     * @param tableName
     * @return
     */
    int syncAccumulateNewsCollect(@Param("tableName")String tableName);

    /**
     *将 Collect 字段设置为0
     * @return
     */
    int updateNewsTotleCollect();
    /**
     *将 share 字段设置为0
     * @return
     */
    int updateNewsTotleShare();


    /**
     *
     * @param tableName  表名
     *
     * @return
     */
    int syncVideoComment(@Param("tableName")String  tableName);

    /**
     *同步帖子评论数
     * @param tableName  表名
     *
     * @return
     */
    int syncForumPostComment(@Param("tableName") String tableName);

    /**
     * 同步帖子点赞数
     * @return
     */
    int syncForumPostLikeCount();

    /**
     * 同步帖子分享数
     * @return
     */
    int syncForumPostShareCount();
    /**
     * 同步帖子收藏数
     * @return
     */
    int syncForumPostCollectCount();

    int selectNewsCommentCount(@Param("tableName") String tableName, @Param("id") Long id);
}
