package com.bxm.localnews.sync.primary.dao;


import com.bxm.localnews.sync.vo.business.NewsCommentStatistic;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsStatistics;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface NewsMapper {

    int save(News localNews);

    int selectCount();

    int selectAllCount();

    int selectMpCount();

    int exists(Long newsId);

    int deleteById(Long newsId);

    List<News> listVideoForTagSync(@Param("type") Byte type, @Param("limitTime") Date time);

    int updateStatusById(@Param("id") Long id, @Param("status") Byte status);

    List<News> listNews(@Param("startLimit") long startLimit,@Param("status") Byte status);

    News selectByPrimaryKey(Long id);

    List<News> queryByPageSize();

    List<News> queryMpByPageSize();

    List<News> queryAllByPageSize();

    int updateByPrimaryKeySelective(News news);

    int updateStatisticByPrimaryKeySelective(NewsStatistics newsStatistics);

    List<Long> getNewsIdByIssueTime();

    int updateNewsCommentById(NewsCommentStatistic newsCommentStatistic);


}
