/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.spider.sync.feign;

import com.bxm.localnews.spider.sync.feign.NewsSearchFeignService;
import com.bxm.localnews.spider.sync.vo.NewsContentParam;
import feign.hystrix.FallbackFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class NewsSearchFeignFallbackFactory
implements FallbackFactory<NewsSearchFeignService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewsSearchFeignFallbackFactory.class);

    public NewsSearchFeignService create(final Throwable throwable) {
        return new NewsSearchFeignService(){

            @Override
            public void remove(List<Long> ids) {
                LOGGER.error("remove news failed\uff0cids\uff1a[{}]", ids);
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public ResponseEntity save(NewsContentParam param) {
                LOGGER.error("save news failed,param:{}", (Object)param);
                LOGGER.error(throwable.getMessage(), throwable);
                System.out.println("#########################################################################################");
                return null;
            }

            @Override
            public ResponseEntity batchSave(List<NewsContentParam> paramList) {
                LOGGER.error("batch save news failed,param:{}", paramList);
                LOGGER.error(throwable.getMessage(), throwable);
                System.out.println("#########################################################################################");
                return null;
            }
        };
    }
}

