package com.bxm.localnews.spider.sync.feign;

import com.bxm.localnews.spider.sync.vo.NewsContentParam;
import feign.hystrix.FallbackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

import java.util.List;

/**
 * 搜索引擎接口调用失败的回调方法
 *
 * @author liujia
 */
public class NewsSearchFeignFallbackFactory implements FallbackFactory<NewsSearchFeignService> {

    private static final Logger LOGGER = LoggerFactory.getLogger(NewsSearchFeignFallbackFactory.class);

    @Override
    public NewsSearchFeignService create(Throwable throwable) {
        return new NewsSearchFeignService() {
            @Override
            public void remove(List<Long> ids) {
                LOGGER.error("remove news failed，ids：[{}]", ids);
                LOGGER.error(throwable.getMessage(), throwable);
            }

            @Override
            public ResponseEntity save(NewsContentParam param) {
                LOGGER.error("save news failed,param:{}", param);
                LOGGER.error(throwable.getMessage(), throwable);
                System.out.println("#########################################################################################");
                return null;
            }

            @Override
            public ResponseEntity batchSave(List<NewsContentParam> paramList) {
                LOGGER.error("batch save news failed,param:{}", paramList);
                LOGGER.error(throwable.getMessage(), throwable);
                System.out.println("#########################################################################################");
                return null;
            }
        };
    }
}
