package com.bxm.localnews.spider.sync.feign;

import com.bxm.localnews.spider.sync.vo.NewsContentParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 搜索引擎调用接口
 * @author liujia
 */
@FeignClient(value = "localnews-search",path="api/news/search/sync/")
public interface NewsSearchFeignService {

    /**
     * 新闻删除时，同步删除搜索引擎中的数据
     * @param ids 新闻ID
     */
    @DeleteMapping
    void remove(List<Long> ids);

    /**
     * 新闻新增或更新，同步更新搜索引擎中的数据
     * @param param 同步参数
     */
    @PostMapping
    ResponseEntity save(NewsContentParam param);

    /**
     * 新闻新增或更新，同步更新搜索引擎中的数据[批量]
     * @param paramList 同步参数
     */
    @PostMapping("/batch")
    ResponseEntity batchSave(@RequestBody List<NewsContentParam> paramList);
}
