package com.bxm.localnews.sync.vo.local;

import lombok.Data;

/**
 * 区域划分实体
 * @author 
 */
@Data
public class AreaDivision {

    /**
     * 主键
     */
    private Long id;

    /**
     * 区域编码
     */
    private String code;

    /**
     * 父级区域编码
     */
    private String parentCode;

    /**
     * 区域名称
     */
    private String name;

    /**
     * 区域全称（从上级一直到当前级别的名称）
     */
    private String fullName;

    /**
     * 是否可用（1表示可用，0表示不可用）
     */
    private Byte enable;

    /**
     * 区域级别（1：省、2：市、3：区、县）
     */
    private Byte level;
}