package com.bxm.localnews.sync.vo.local;

import lombok.Data;

import java.io.Serializable;

/**
 * 用户定位信息配置实体
 *
 */
@Data
public class Location implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 地区编码
     */
    private String code;

    /**
     * 地区简称
     */
    private String name;

    /**
     * 地区全称
     */
    private String fullName;

    /**
     * 是否热门城市（1表示true）
     */
    private Byte hot;

    /**
     * 是否显示（1表示true）
     */
    private Byte show;

    /**
     * 城市级别（2：市、3：县（区））
     */
    private Byte level;

    /**
     * 城市拼音或者首字母
     */
    private String pinyin;

    /**
     * 纬度
     */
    private Double lat;

    /**
     * 经度
     */
    private Double lng;

}