package com.bxm.localnews.analysis;

import com.bxm.localnews.sync.vo.Keyword;

import java.util.List;
/**
 * 对文章进行解析，根据TF-IDF算法，在计算的同时也进行IDF既有词库的更新维护
 *
 * @author liujia
 */
public interface TFIDFAnalyzesService {

    /**
     * 去除content中的html标签部分，分解后与title一起作为TF值计算的标准
     * 调用python的关键词提取服务，然后返回排序后的结果的topN
     *
     * @param title   解析内容的标题部分
     * @param content 需要分析的文本/文档内容
     * @param topN    返回最终结果的关键特征数量
     * @return 关键字（特征）
     */
    List<Keyword> analyze(String title, String content, int topN);
}

