package com.bxm.localnews.analysis.impl;

import com.bxm.localnews.analysis.TFIDFAnalyzesService;
import com.bxm.localnews.sync.service.SegmentIntegrationService;
import com.bxm.localnews.sync.vo.Keyword;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 对文章进行解析，根据TF-IDF算法，在计算的同时也进行IDF既有词库的更新维护
 *
 * @author liujia
 */
@Service
public class TFIDFAnalyzeServiceImpl implements TFIDFAnalyzesService {

    private SegmentIntegrationService segmentIntegrationService;

    @Autowired
    public TFIDFAnalyzeServiceImpl(SegmentIntegrationService pythonIntegrationService) {
        this.segmentIntegrationService = pythonIntegrationService;
    }

    public List<Keyword> analyze(String title, String content, int topN) {
        return segmentIntegrationService.segTags(title + content, topN);
    }
}
