package com.bxm.localnews.channel;

/**
 * 数据通道接口，用于将原始数据输送到目标地址
 */
public interface DataChannelService<T> {

    /**
     * 保存对象
     * @param data
     */
    void save(T data);

    /**
     * 数据移除,如果数据状态变为待同步或废弃，同步将业务库中的数据进行变更
     * @param data
     */
    void remove(T data);

    /**
     * 数据更新,数据同步前会判断是否为重复数据，如果重复则进行更新，并且在成功更新后中断后续处理
     * @param data
     * @return 发生异常或因为重复导致原始新闻不存在，则返回false
     */
    boolean modify(T data);

    /**
     * 数据写入前的清理动作，非必须，会在保存数据前进行判断
     * @param data 写入数据
     */
    default void clear(T data) {

    }

    /**
     * 当前传输通道支持的数据类型
     * @return true表示可以对该类型进行处理
     */
    default Class<T> supports() {
        return null;
    }
}
