package com.bxm.localnews.channel.impl;

import com.bxm.localnews.convert.impl.AdminNewsEntryConverter;
import com.bxm.localnews.convert.impl.AdminNewsUpdateConverter;
import com.bxm.localnews.sync.primary.dao.NewsStatisticsMapper;
import com.bxm.localnews.sync.vo.local.AdminNews;
import com.bxm.localnews.sync.vo.local.News;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 管理后台新闻数据修改包括:
 * 新闻新增
 * 新闻修改
 * 新闻上下架
 * 新闻审核
 */
@Component
public class AdminNewsDataChannelServiceImpl extends AbstractNewsDataChannelServiceImpl<AdminNews> {

    private final AdminNewsEntryConverter adminNewsEntryConverter;

    private final AdminNewsUpdateConverter adminNewsUpdateConverter;

    @Autowired(required = false)
    public AdminNewsDataChannelServiceImpl(AdminNewsUpdateConverter adminNewsUpdateConverter,
                                           NewsStatisticsMapper newsStatisticsMapper,
                                           AdminNewsEntryConverter adminNewsEntryConverter) {
        this.adminNewsEntryConverter = adminNewsEntryConverter;
        this.adminNewsUpdateConverter = adminNewsUpdateConverter;
        this.newsStatisticsMapper = newsStatisticsMapper;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(AdminNews data) {
        logger.debug("管理后台操作数据新增:{}", data.getId());
        News localNews = this.adminNewsEntryConverter.convert(data);
        saveNews(localNews);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void clear(AdminNews data) {
        News news =new News();
        news.setId(data.getId());
        news.setStatus(data.getStatus());
        this.clearDirtyData(news);
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void remove(AdminNews data) {
        News news = new News();
        news.setAreaDetail(data.getAreaDetail());
        news.setId(data.getId());
        news.setStatus(data.getStatus());
        remove(news);
    }

    @Override

    public boolean modify(AdminNews data) {
        return modifyNews(this.adminNewsUpdateConverter.convert(data));
    }

    @Override
    public Class<AdminNews> supports() {
        return AdminNews.class;
    }

}
