package com.bxm.localnews.channel.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.channel.DataChannelService;
import com.bxm.localnews.convert.impl.ForumPostConverter;
import com.bxm.localnews.sync.primary.dao.ForumPostMapper;
import com.bxm.localnews.sync.primary.dao.NewsReplyMapper;
import com.bxm.localnews.sync.primary.dao.UserReplyMapper;
import com.bxm.localnews.sync.second.dao.NewsCommentMapper;
import com.bxm.localnews.sync.vo.local.ForumPost;
import com.bxm.localnews.sync.vo.spider.SpiderForumPost;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ForumPostChannelServiceImpl implements DataChannelService<SpiderForumPost> {
    private final ForumPostConverter forumPostConverter;
    private final ForumPostMapper forumPostMapper;

    @Autowired
    public ForumPostChannelServiceImpl(ForumPostConverter forumPostConverter, ForumPostMapper forumPostMapper) {
        this.forumPostConverter = forumPostConverter;
        this.forumPostMapper = forumPostMapper;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SpiderForumPost data) {
        ForumPost forumPost = this.forumPostConverter.convert(data);
        // 保存帖子
        forumPostMapper.savePost(forumPost);
        // 保存评论
        if (!CollectionUtils.isEmpty(forumPost.getReplyList())) {
            MybatisBatchBuilder.create(NewsReplyMapper.class, forumPost.getReplyList()).sessionTemplateName("primarySessionTemplate").run(NewsReplyMapper::insertSelective);
            MybatisBatchBuilder.create(UserReplyMapper.class, forumPost.getReplyList()).sessionTemplateName("primarySessionTemplate").run(UserReplyMapper::insertSelective);
        }
        //保存帖子话题
        if (null!=forumPost.getForumPostTopic()){
            forumPostMapper.savePostTopic(forumPost.getForumPostTopic());
        }
    }

    @Override
    public void remove(SpiderForumPost data) {

    }

    @Override
    public boolean modify(SpiderForumPost data) {
        return false;
    }

    @Override
    public void clear(SpiderForumPost data) {

    }

    @Override
    public Class<SpiderForumPost> supports() {
        return SpiderForumPost.class;
    }
}
