package com.bxm.localnews.channel.impl;

import com.bxm.localnews.convert.impl.NewsConverter;
import com.bxm.localnews.sync.primary.dao.NewsStatisticsMapper;
import com.bxm.localnews.sync.primary.dao.NewsTagMapper;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.spider.SpiderNews;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;


@Component
public class NewsDataChannelServiceImpl extends AbstractNewsDataChannelServiceImpl<SpiderNews> {

    private final NewsConverter newsConverter;

    @Autowired(required = false)
    public NewsDataChannelServiceImpl(NewsConverter newsConverter,
                                      NewsStatisticsMapper newsStatisticsMapper,
                                      NewsTagMapper newsTagMapper
                                      ) {
        this.newsConverter = newsConverter;
        this.newsStatisticsMapper = newsStatisticsMapper;
        this.newsTagMapper = newsTagMapper;

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(SpiderNews data) {
        News localNews = this.newsConverter.convert(data);
        saveNews(localNews);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void clear(SpiderNews data) {
        News news =new News();
        news.setAreaDetail(data.getRegion());
        news.setId(data.getId());
        news.setStatus(data.getStatus());
        this.clearDirtyData(news);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void remove(SpiderNews data) {
        News news =new News();
        news.setAreaDetail(data.getRegion());
        news.setId(data.getId());
        news.setStatus(data.getStatus());
        remove(news);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean modify(SpiderNews data) {
        return modifyNews(this.newsConverter.convert(data));
    }

    @Override
    public Class<SpiderNews> supports() {
        return SpiderNews.class;
    }

}
