package com.bxm.localnews.channel.impl;

import com.bxm.localnews.sync.primary.dao.NewsPoolMapper;
import com.bxm.localnews.sync.primary.dao.NewsStatisticsMapper;
import com.bxm.localnews.sync.primary.dao.NewsTagMapper;
import com.bxm.localnews.sync.vo.local.NewsPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NewsPoolDataChannelServiceImpl extends AbstractNewsDataChannelServiceImpl<NewsPool> {


    private final NewsPoolMapper newsPoolMapper;

    @Autowired(required = false)
    public NewsPoolDataChannelServiceImpl(NewsPoolMapper newsPoolMapper,
                                          NewsStatisticsMapper newsStatisticsMapper,
                                          NewsTagMapper newsTagMapper) {
        this.newsPoolMapper = newsPoolMapper;
        this.newsStatisticsMapper = newsStatisticsMapper;
        this.newsTagMapper = newsTagMapper;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(NewsPool data) {
        newsPoolMapper.save(data);
    }

    @Override
    public void clear(NewsPool data) {

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void remove(NewsPool data) {

    }

    @Override
    public boolean modify(NewsPool data) {
       return false;
    }

    @Override
    public Class<NewsPool> supports() {
        return NewsPool.class;
    }
}
