package com.bxm.localnews.channel.impl;

import com.bxm.localnews.convert.impl.NewsStatusConverter;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsRecommended;
import com.bxm.localnews.sync.vo.local.NewsStatus;
import com.bxm.localnews.sync.vo.local.NewsTag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;


@Component
public class NewsStatusDataChannelServiceImpl extends AbstractNewsDataChannelServiceImpl<NewsStatus> {

    private final NewsStatusConverter newsStatusConverter;

    @Autowired(required = false)
    public NewsStatusDataChannelServiceImpl(
            NewsStatusConverter newsStatusConverter) {
        this.newsStatusConverter = newsStatusConverter;

    }

    @Override
    public void save(NewsStatus data) {
    }

    @Override
    public void clear(NewsStatus data) {
    }


    @Override
    public void remove(NewsStatus data) {
    }

    @Override

    public boolean modify(NewsStatus data) {
        return modifyNews(this.newsStatusConverter.convert(data));
    }

    @Override
    public Class<NewsStatus> supports() {
        return NewsStatus.class;
    }


    /**
     * 默认是删了再加,删除推荐数据，并在原有表上更新，保存之前的标签
     * @param news
     * @return
     */
    @Override
    boolean modifyNews(News news) {
        //判断新闻是否存在
        News oldNews = newsMapper.selectByPrimaryKey(news.getId());
        if (oldNews!=null) {
            //删除历史数据
            clearNewsAging(oldNews);
            //保存新数据
            updateNewsStatus(news,oldNews);

            logger.debug("管理后台操作数据(状态)变更:{}", news.getId());

            return true;
        }

        return false;
    }

    /**
     * 更新新闻的状态，根据状态确定是否加入推荐池
     * @param data
     * @param oldNews
     */
    private void updateNewsStatus(News data, News oldNews) {
        List<NewsTag> newsTagList = newsTagMapper.selectByNewsId(data.getId());
        List<NewsRecommended> newsRecommendedList = newsRecommendedMapper.selectByNewsId(data.getId());

        //保存新闻-总记录表
        this.newsMapper.updateStatusByPrimaryKeySelective(data);

        if (null != data.getStatus()) {
            oldNews.setStatus(data.getStatus());
        }

        if (null != data.getReviewStatus()) {
            oldNews.setReviewStatus(data.getReviewStatus());
        }

        if (null != data.getHot()) {
            oldNews.setHot(data.getHot());
        }

        //未审核的新闻不需要进入推荐池中
        if (2 != oldNews.getReviewStatus() || 1 != oldNews.getStatus()) {
            return;
        }

        //置顶
        if (oldNews.getTop() == 2 || oldNews.getKindTop() == 2) {
            return;
        }

        //热门
        if (oldNews.getHot() == 2) {
            putNewsToHotRecommendPool(oldNews, newsRecommendedList);
            return;
        }

        //本地
        if (null != oldNews.getAreaDetail()) {
            putNewsToLocalRecommendPool(oldNews, newsTagList, newsRecommendedList);
            return;
        }

        //全国表
        putNewsToNationalRecommendPool(oldNews, newsTagList, newsRecommendedList);


    }

}
