package com.bxm.localnews.constant;

import java.util.Map;

import com.bxm.localnews.processer.IProcesser;
import com.bxm.localnews.processer.impl.*;
import com.google.common.collect.Maps;

/**
 * 处理器排序,数值越小，处理器的优先级越高，排序过后的处理器会形成处理器链
 */
public class ProcesserOrder {

    private static Map<Class<? extends IProcesser>, Integer> processerOrderMap = Maps.newHashMap();

    static {
        //数据状态变更处理
        processerOrderMap.put(RemoveProcesser.class, 1);
        processerOrderMap.put(ModifyProcesser.class, 2);

        //新闻处理
        processerOrderMap.put(NewsRepeatProcesser.class, 3);
        processerOrderMap.put(NewsKeywordProcesser.class, 4);

        //小视频处理
        processerOrderMap.put(VideoKeywordProcesser.class, 5);

        //idataApi爬取视频处理
        processerOrderMap.put(IDataVideoKeywordProcesser.class, 6);

        //数据存储处理
        processerOrderMap.put(SaveProcesser.class, 998);
        processerOrderMap.put(DefaultProcesser.class, 999);
    }

    public static int get(Class<? extends IProcesser> clasz) {
        return processerOrderMap.get(clasz);
    }
}
