package com.bxm.localnews.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

public class RedisKey {
    /**
     * 新闻同步的最后时间记录
     */
    public static final KeyGenerator SPIDER_NEWS_SYNC = DefaultKeyGenerator.build("sync", "spider", "news");

    /**
     * 优惠券同步的最后时间记录
     */
    public static final KeyGenerator SPIDER_COUPON_SYNC = DefaultKeyGenerator.build("sync", "spider", "coupon");

    /**
     * 微信同步的最后时间记录
     */
    public static final KeyGenerator SPIDER_WECHAT_SYNC = DefaultKeyGenerator.build("sync", "spider", "wechat");

    /**
     * 帖子同步的最后时间记录
     */
    public static final KeyGenerator SPIDER_FORUM_SYNC = DefaultKeyGenerator.build("sync", "spider", "forum");

    /**
     * 视频同步的最后时间记录
     */
    public static final KeyGenerator SPIDER_VIDEO_SYNC = DefaultKeyGenerator.build("sync", "spider", "video");

    /**
     * 缓存最近15天的新闻simhash值
     */
    public static final KeyGenerator SPIDER_SIMHASH_CACHE = DefaultKeyGenerator.build("sync", "spider", "simhash");

    /**
     * 公共标签记录
     */
    public static final KeyGenerator SPIDER_TAG_INDEX = DefaultKeyGenerator.build("sync", "spider", "tag");

    /**
     * 帖子id
     */
    public static KeyGenerator SEQ_POST_ID = DefaultKeyGenerator.build("seq", "post", "id");

}
