package com.bxm.localnews.convert.impl;

import com.bxm.localnews.sync.enums.LocalNewsTypeEnum;
import com.bxm.localnews.sync.vo.local.AdminNews;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.newidea.component.tools.RandomUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Objects;

@Component
public class AdminNewsEntryConverter extends AbstractConverter<AdminNews, News> {

    @Override
    public News convert(AdminNews data) {

        News localNews = new News();
        localNews.setId(data.getId());
        localNews.setContent(data.getContent());
        localNews.setVideoList(data.getVideoList());
        localNews.setTitle(data.getTitle());
        localNews.setKindId(data.getKindId());
        localNews.setKindName(data.getKindName());

        localNews.setAddress(data.getAddress());
        localNews.setAuthor(data.getAuthor());
        localNews.setKeywordList(data.getKeywordList());
        localNews.setType(LocalNewsTypeEnum.NEWS.getCode());
        localNews.setAddTime(data.getAddTime());
        localNews.setModifyTime(data.getAddTime());
        localNews.setIssueTime(data.getIssueTime());
        localNews.setPublishTime(data.getPublishTime());
        localNews.setHotExpireTime(data.getHotExpireTime());
        localNews.setTopExpireTime(data.getTopExpireTime());

        localNews.setStatus(data.getStatus());
        localNews.setReviewStatus(data.getReviewStatus());
        localNews.setImgUrl(data.getImgUrl());
        localNews.setEditorMessage(data.getEditorMessage());
        localNews.setEditorMessageId(data.getEditorMessageId());
        localNews.setCoverList(data.getCoverList());
        localNews.setEnablePlaceholder(data.getEnablePlaceholder());
        localNews.setReviewStatus(data.getReviewStatus());
        localNews.setIsBootDownload(data.getIsBootDownload());
        localNews.setCoverSelect(Objects.isNull(data.getCoverSelect()) ? 0 : data.getCoverSelect());
        localNews.setAreaDetail(StringUtils.isNotBlank(data.getAreaDetail())?data.getAreaDetail():null);
        localNews.setDeliveryType(data.getDeliveryType());

        localNews.setTop(data.getTop());
        localNews.setKindTop(data.getKindTop());
        localNews.setHot(data.getHot());

        localNews.setClicks(RandomUtils.nextInt(2000, 6000));
        localNews.setViews(RandomUtils.nextInt(2000, 6000));
        localNews.setCollects(0);
        localNews.setComments(0);
        localNews.setRecommends(100);
        localNews.setActiveViews(RandomUtils.nextInt(2000, 6000));
        localNews.setShares(0);
        localNews.setNewClicks(RandomUtils.nextInt(2000, 6000));


        return localNews;
    }
}
