package com.bxm.localnews.convert.impl;

import java.math.BigDecimal;
import java.util.Date;

import com.bxm.localnews.convert.Converter;
import com.bxm.localnews.sync.vo.local.LocalVideo;
import com.bxm.localnews.sync.vo.spider.IDataVideo;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;

import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2018/12/12 9:48
 * @desc
 */
@Component
@Deprecated
public class IDataVideoConverter implements Converter<IDataVideo, LocalVideo> {

    @Override
    public LocalVideo convert(IDataVideo data) {
        LocalVideo localVideo = new LocalVideo();
        localVideo.setId(Long.valueOf(data.getId()));
        localVideo.setDescription(data.getDescription());
        localVideo.setTitle(data.getTitle());
        localVideo.setVideoImg(data.getCoverUrl());
        //设置为第一个播放视频地址
        localVideo.setVideoUrl(data.getVideoUrls().get(0));
        localVideo.setAuthorImg("");
        localVideo.setAuthorName(data.getPosterScreenName());
        localVideo.setCreateTime(new Date());
        localVideo.setIssueTime(DateUtils.parseDateNonStrict(data.getPublishDateStr()));
        localVideo.setCommentCount(0L);
        localVideo.setShareCount(0L);
        localVideo.setClickCount(RandomUtils.nextLong(500, 50000));
        BigDecimal rate = new BigDecimal((RandomUtils.nextInt(3, 40))).divide(new BigDecimal(100));
        BigDecimal likeCount = rate.multiply(new BigDecimal(localVideo.getClickCount()));
        localVideo.setLikeCount(likeCount.longValue());
        //视频状态（0：无效，1：有效）
        localVideo.setStatus((byte) 1);
        //是否已删除(0:未删除，1：已删除)
        localVideo.setIsDelete((byte) 0);
        localVideo.setKeywordList(data.getKeywordList());
        localVideo.setWidthRatio(data.getWidthRatio());

        return localVideo;
    }
}
