package com.bxm.localnews.convert.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.sync.enums.LocalNewStatusEnum;
import com.bxm.localnews.sync.enums.LocalNewsTypeEnum;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsImg;
import com.bxm.localnews.sync.vo.spider.SpiderNews;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.github.pagehelper.util.StringUtil;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 将新闻转换为本地新闻
 */
@Component
public class NewsConverter extends AbstractConverter<SpiderNews, News> {

    @Override
    public News convert(SpiderNews spiderNews) {
        News localNews = new News();
        localNews.setId(spiderNews.getId());

        List<NewsImg> newsVideoList = new ArrayList<>();
        localNews.setContent(extractVideo(spiderNews.getContent(), newsVideoList));
        if (!CollectionUtils.isEmpty(newsVideoList)) {
            localNews.setVideoList(JSONObject.toJSONString(newsVideoList));
        }
        localNews.setTitle(spiderNews.getTitle());
        String[] imgArray = StringUtils.isEmpty(spiderNews.getImgUrl()) ? null : spiderNews.getImgUrl().split(";");
        localNews.setImgUrl(imgArray == null ? "" : this.toJsonString(imgArray));
        localNews.setAuthor(StringUtils.isEmpty(spiderNews.getSource()) ? "匿名" : spiderNews.getSource());
        localNews.setAddress(spiderNews.getUrl());
        localNews.setAddTime(spiderNews.getCreateTime());
        localNews.setModifyTime(spiderNews.getCreateTime());
        localNews.setStatus(LocalNewStatusEnum.ENABLE.getCode());
        localNews.setType(LocalNewsTypeEnum.NEWS.getCode());
        localNews.setTop((byte) 1);
        //是否是热文 1：否  2：是
        localNews.setHot((byte) 1);
        localNews.setChannel((byte) 8);
        localNews.setKindId(this.getKindId(spiderNews.getChannel()));
        localNews.setKindName(spiderNews.getChannel());
        localNews.setKeywordList(spiderNews.getKeywordList());
        localNews.setSource(spiderNews.getSource());
        localNews.setReviewStatus((byte) 2);
        localNews.setKindTop((byte) 1);
        localNews.setEnablePlaceholder((long) 0);
        localNews.setCoverSelect((byte) 0);
        localNews.setDeliveryType(0);
        generateNewsStatistic(localNews);

        //保存地区
        if (StringUtil.isNotEmpty(spiderNews.getRegion())) {
            localNews.setAreaDetail(spiderNews.getRegion());
            localNews.setReviewStatus((byte) 0);
            localNews.setDeliveryType(1);
            logger.debug("（修改和新增都会调用convert方法）本地新闻保存->{};{}", localNews.getTitle(), localNews.getDeliveryType());
        }
        if (!CollectionUtils.isEmpty(spiderNews.getCommentList())) {
            localNews.setNewsReplyList(convertNewsCommentToNewReply(spiderNews.getCommentList()));
        }

        //有点蠢的代码，但是毫无办法
        try {
            if (StringUtils.isNotEmpty(spiderNews.getDeployTime())) {
                Date date = DateUtils.parseDateNonStrict(spiderNews.getDeployTime());
                Date maxDate = DateUtils.parseDate("2038-01-01 00:00:00");
                Date minDate = DateUtils.parseDate("1980-01-01 00:00:00");
                if (DateUtils.after(date, maxDate) || DateUtils.after(minDate, date)) {
                    localNews.setIssueTime(spiderNews.getCreateTime());
                } else {
                    localNews.setIssueTime(date);
                }
            } else {
                localNews.setIssueTime(spiderNews.getCreateTime());
            }
        } catch (Exception e) {
            logger.error("时间格式转换错误:[{}]", JSONObject.toJSONString(spiderNews));
            localNews.setIssueTime(spiderNews.getCreateTime());
        } finally {
            if (localNews.getIssueTime() == null) {
                logger.warn("时间为空，需要补充:[{}]", JSONObject.toJSONString(spiderNews));
                localNews.setIssueTime(new Date());
            }
        }

        return localNews;
    }




}
