package com.bxm.localnews.convert.impl;

import com.bxm.localnews.service.VirtualUserService;
import com.bxm.localnews.sync.vo.business.VirtualUser;
import com.bxm.localnews.sync.vo.local.NewsReply;
import com.bxm.localnews.sync.vo.spider.NewsComment;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;


@Component
public class NewsReplyConverter {

    @Autowired
    private VirtualUserService virtualUserService;

    /**
     *
     * @param resultList 返回的结果集
     * @param newsComment 需要转化的评论
     * @return
     */
    public List<NewsReply> judgeNewsReplyLevel(List<NewsReply> resultList, NewsComment newsComment){
        if(Objects.isNull(newsComment)){
            return resultList;
        }
        if (Objects.isNull(newsComment.getParentId())) {
            NewsReply newsReply = newsCommentToReply(newsComment);
            int praiseTimes = newsComment.getPraiseTimes()==null?0:newsComment.getPraiseTimes();
            int commentTimes = newsComment.getCommentTimes()==null?0:newsComment.getCommentTimes();
            newsReply.setInteractiveCount(praiseTimes+commentTimes*3);

            resultList.add(newsReply);
        }

        return resultList;
    }

    private NewsReply newsCommentToReply(NewsComment newsComment){
        NewsReply reply = new NewsReply();
        reply.setInteractiveCount(0);
        reply.setDeleteFlag((byte)0);
        reply.setType(newsComment.getType());

        List<VirtualUser> virtualUserList = SpringContextHolder.getBean(VirtualUserService.class).list();
        VirtualUser virtualUser = virtualUserList.get((int) (Math.random()* virtualUserList.size()));

        reply.setHeadImg(virtualUser.getHeadImg());
        reply.setUserId(virtualUser.getId());
        reply.setUserNickname(virtualUser.getNickname());

        reply.setNewsId(newsComment.getSourceId());
        reply.setAddTime(newsComment.getCreateTime());
        reply.setId(newsComment.getId());
        reply.setLikeCount(newsComment.getPraiseTimes());
        reply.setDeleteFlag((byte)0);

        reply.setStatus((byte)1);
        reply.setRootId(0L);
        reply.setLevel((byte) 0);
        reply.setParentId(0L);
        if (StringUtils.isNotBlank(newsComment.getContent()) && newsComment.getContent().length() > 500){
            reply.setReplyContent( newsComment.getContent().substring(0,500));
        }else{
            reply.setReplyContent(newsComment.getContent());
        }

        return reply;
    }
}
