package com.bxm.localnews.convert.impl;

import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsStatistics;
import org.springframework.stereotype.Component;

@Component
public class NewsStatisticConverter extends AbstractConverter<NewsStatistics, News>{


    @Override
    public News convert(NewsStatistics data) {
        News localNews = new News();
        localNews.setId(data.getNewsId());
        localNews.setClicks(data.getClicks());
        localNews.setViews(data.getViews());
        localNews.setCollects(data.getCollects());
        localNews.setComments(data.getComments());
        localNews.setRecommends(data.getRecommends());
        localNews.setActiveViews(data.getActiveViews());
        localNews.setShares(data.getShares());
        localNews.setNewClicks(data.getNewClicks());
        return localNews;
    }
}
